<?php

require_once("vendor/autoload.php");
//use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\IOFactory;

function DispExcel($SpreadSheet, $DispType){
    $xlsReader = IOFactory::createReader('Xlsx');
    
    $index = array();
    $data  = array( array() );
    $html  = '';
    $project = '';
    
    // ファイル読み込み
    $xlsObject = $xlsReader->load($SpreadSheet['fname']);
    
    // 指定のシート
    $xlsObject->setActiveSheetIndex($SpreadSheet['sheetIndex']);
    $xlsSheet = $xlsObject->getActiveSheet();

    // 行数・列数を取得
    $rowMax = $xlsSheet->getHighestRow()+1;
    $colMaxStr = $xlsSheet->getHighestColumn();
    $colMax = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::columnIndexFromString($colMaxStr)+1;
    
    //redmine project の場合
    if (substr($DispType,0,7) == 'redmine'){
        $project = substr($DispType,8);
        $DispType = 'redmine';
    }
    
    // セルを読んで$data[row][col]に入れる。
    for ($row=1; $row<=$rowMax; $row++){
        $line = '';
        for ($col=1; $col <= $colMax; $col++){
            $cell = $xlsSheet->getCellByColumnAndRow($col, $row);
            if (($row > 1) && ($col == 1) && ($DispType == 'redmine')){
                $cellStr = '<a href="./redmine_issue/' . $project . '-' . $cell->getValue() . '.pdf">' . $cell->getValue() . '</a>';
            }else if ($cell->hasHyperlink()){ // セル内のリンクを変換
                $cellStr = '<a href="' . $cell->getHyperlink()->getUrl() . '">' . $cell->getValue() . '</a>';
            }else{
                $cellStr = $cell->getCalculatedValue();
                //$cellStr = $cell->getFormattedValue();
            }
            $data[$row][$col] = preg_replace('/\r?\n/', "<br />\n", $cellStr);
            $line .= $cellStr;
        }
        if ($line == ''){
            $rowMax = $row;
            break;
        }
    }
    
    // リスト形式で表示
    if ($DispType == 'list'){
        // 各参加者へのリンク
        $html .= '<ul>';
        for ($row = 2; $row < $rowMax; $row++){
            $html .= '<li><a href="#' . $row . '">' . $data[$row][1] . "</a> さん\n";
        }
        $html .= '</ul>';
        
        // $data[row][0] を <h3> に入れ、あとは <dl><dd>に入れる。
        for ($row = 2; $row < $rowMax; $row++){
            $html .= '<a name="' . $row . '"></a><h3>' . $data[$row][1] . " さん</h3>\n";
            $html .= '<table>' . "\n";
            for ($col=2; $col < $colMax; $col++){
                if (! $data[$row][$col]){ continue; }
                $html .= ' <tr><td align="left" valign="top" style="padding:2px 4px;"><b>' . $data[1][$col] . "</b></td>\n";
                $html .= ' <td style="padding:2px 6px;">' . $data[$row][$col] . "</td></tr>\n";
            }
            $html .= "</table>\n";
        }
    }
    // テーブルとして出力
    else{
        $html .= "<table>\n";
        for ($row = 1; $row < $rowMax; $row++){
            $html .= "<tr>\n";
            for ($col=1; $col < $colMax; $col++){
                $html .= ($row==1)? ' <th>' . $data[$row][$col] . "</th>\n" : ' <td> ' . $data[$row][$col] . "</td>\n";
            }
            $html .= "</tr>";
        }
        $html .= "</table>\n";
    }
    return $html;
}
?>