
=doc

.txt→.htm の変換を行う。文字コードは入出力共に UTF-8 を想定している。

○使い方（変換方法）
    > perl conv_txt2h.pl hoge.txt

○処理内容

　・改行 → <br>
　・空行（連続改行）→<p>
　・空行を前後に開けて "-" が 3つ以上 → <hr width="50%">（前後の改行は保持）
　・title: → <h1>～</h1> および <title>～</title>
　・subtitle: → <h2>～</h2>
　・ヘッダは、スクリプト中の $header になる。
　・最初の「・」→<li>

=cut

use utf8;
$DASHLEN_END = 10;

#--------------------------------------------
my $header =<<EOH;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0//EN">
<html>
<head>
<title lang="ja">TITLE_HEADER</title>
<META HTTP-EQUIV="Content-Type" CONTENT="text/html;CHARSET=utf-8">
<meta name="Author" content="Yunzo, Alicemagic">
<style type="text/css"><!--
BODY { line-height: 1.50; letter-spacing: 1px; width: 48em; 
       margin-right: 5%; margin-left: 5%; margin-top: 1em; margin-bottom: 2em; }
H1,H2,H3,H4,H5,H6,PRE { line-height: 1.20; text-align: left; }
P { line-height: 1.50; text-indent: 1em; }
P.noindent { text-indent: 0em; }
LI P, DD P { text-indent: 0; }
P,UL,OL,DL,LI,DD,PRE,BLOCKQUOTE{margin-top: 0.5em; margin-bottom: 0.5em; }
STRONG { font-weight: bolder }
BLOCKQUOTE { margin-left: 2em; }
ADDRESS { margin: 1.5em 1em 1em 2em; line-height: 1.20; font-style: normal; }
--></style>
</head>

<body bgcolor=#D8FFFF text=#000000>

TITLE
SUBTITLE

EOH

#--------------------------------------------
if ($ARGV[0] eq ''){
	print "usage: perl conv_txt2h.pl TXTFILE\n";
	exit;
}elsif(! -e $ARGV[0]){
	print "in_fname not found.\n";
	exit;
}

#--------------------------------------------
my ($text, $html, $title, $title_header, $subtitle);
open(TXT, '<:encoding(UTF-8)', "$ARGV[0]");

for ($i = 0; $i < 5; ){
	$text = <TXT>;
	$text =~ s/[\r\n]+$/\n/;
	if ($text eq ''){
		continue;
	}elsif ($text =~ /^(title|subtitle):(.+)\n$/i){
		if ($1 eq 'title'){
			$title_header = $2;
			$title = "<h1>" . $2 . "</h1>";
		}elsif ($1 eq 'subtitle'){
			$subtitle = "<h2>" . $2 . "</h2>";
		}
	}else{
		$html .= $text;
	}
	$i++;
}

while($text = <TXT>){
	$text =~ s/[\r\n]+$/\n/;
	$text =~ s/^ +//; # ltrim()
	$html .= $text;
}
close(TXT);

&convText(\$html);

#--------------------------------------------
my $out_fname = $ARGV[0];
$out_fname =~ s/\.txt$/.htm/i;
if ($out_fname eq $ARGV[0]){
	$out_fname .= '.htm';
}

$header =~ s/SUBTITLE/$subtitle/e;
$header =~ s/TITLE_HEADER/$title_header/e;
$header =~ s/TITLE/$title/e;
$header =~ s/\r\n/\n/g;
$header =~ s/\n+$/\n\n/s;

open(HTML, '>:encoding(UTF-8)', "$out_fname");
print HTML $header;
print HTML $html;
print HTML "\n\n<hr>\n\n</body>\n</html>\n";
close(HTML);

#--------------------------------------------

sub convText(\$){
	my ($html) = @_;
	
	$$html =~ s/^[\s\r\n]*/\n\n/; # 先頭
	$$html =~ s/[\-\s\r\n]+$//;   # 末尾

	# コメント内のタグを削除。+? で最短距離一致にしなければならないことに注意
	$$html =~ s/<!--(.+?)-->/ "<!--" . &deleteTags($1) . "-->" /exgs;

	# ----- を <hr width="50%" /> または <hr> に変換
	$$html =~ s!\n{2,}(\-{3,})\s*\n{2,}!{
		if (length($1) > $DASHLEN_END){
			"\n\n<hr />\n\n";
		}else{
			"\n\n<hr width\=\"50\%\" />\n\n";
		}
	}!egs; 
	
	# 空行があれば <p> に変換し、 <p>< を戻す
	$$html =~ s!\n{2,}!\n\n<p>!gs;
	$$html =~ s!<p>(\n*?)<!$1<!gs;

	# 空行の無い改行を行頭の <br> に変換し、<br>< を戻す
	$$html =~ s!\n([^\n<])!\n<br>$1!gs;
	$$html =~ s!<br>(\n*?)<!$1<!gs;

	# 空行の無い改行を行末の <br> に変換し、\n<br>\n を戻す
	#  $$html =~ s!([^\n>])\n!$1<br>\n!gs;
	#  $$html =~ s!\n<br>\n!\n\n!gs;

	# 箇条書きを <ul><li> に変換し、直後の<br>は消去
	$$html =~ s!((<br>・[^\n]+\n)+)<br>!<ul>\n$1</ul>\n!gs;
	$$html =~ s!<br>・([^\n]+)\n!<li>$1\n!gs;

	$$html =~ s/\r/\n/gs;
	$$html =~ s/^\n\n//;
}

sub deleteTags($){
	my ($tag) = @_;
	$tag =~ s/<[^>]+>//sg;
	$tag =~ s/\n/\r/sg;
	return $tag;
}
  
#--------------------------------------------
